	subroutine genvar(nob,nextra,k,np,rho,phi,x)
c
c**********************************************************************
c
c   FORTRAN subroutine to generate a k-variate vector autoregressive
c   process of order np.  The cross-correlation of the errors is rho.
c
c   Input: nob = an integer containing the desired number of realiza-
c                tions.
c          nextra = an integer specifying the number of initial
c                   values to generate (nextra >> np+k).
c          k = an integer containing the number of time series.
c          np = an integer containing the order of the autoregressive
c               process.
c          rho = a double precision real scalar containing the value
c                of the correlation between errors at the same time
c                point.
c          phi = a double precision three dimensional array having
c                dimension np x k x k containing the coefficients
c                of the vector autoregressive process.  phi(ii,jj,kk)
c                is the iith coefficient for the jjth time series.
c
c   Output: x = a double precision matrix of dimension nob x k 
c		      containing the realization of the vector autoregressive
c               process.
c
c   Accuracy: Implicit double precision (a-h,p-z).
c
c   Created: 7/19/97 Bonnie Ray
c   Modified: 7/23/97 Jane L. Harvill
c
c   Subprograms called: IMSL subroutine DCHFAC, IMSL subroutine DRNMVN,
c                       IMSL double precision function DMACH
c
c**********************************************************************
c
	parameter (nkmx = 5, nmx = 2500, npmx = 5)
	parameter (nqmx = (npmx*nkmx)**2)
 	implicit double precision (a-h, p-z)
c
	integer nob,nextra,k,np
c
	double precision cov(nkmx,nkmx),eps(nmx,nkmx),x(nmx,nkmx)
	double precision phi(npmx,nkmx,nkmx)
c
c	external DCHFAC, DRNMVN, DMACH
c
c   Initialize matrices and constants:
c
	do i = 1,nmx
	do j = 1,nkmx
		eps(i,j) = 0.0d0
	enddo
	enddo
c
c   Set covariance matrix (cov):
c
	do i = 1,k
	do j = 1,k
		if(i.eq.j) then
			cov(i,j) = 1.0d0
		else
			cov(i,j) = rho
		endif
	enddo
	enddo
c
c   Use IMSL subroutines.
c
c   The subroutine DCHFAC computes an upper triangular factorization of 
c   a real symmetric nonnegative definite matrix.  The result is returned
c   in the matrix cov.
c
c   The subroutine DRNMVN generates pseudorandom numbers from a 
c   multivariate normal distribution.  The result is returned in the
c   vector eps.
c
	call DCHFAC(k,cov,nkmx,100.0d0*dmach(4),irank,cov,nkmx)
	call DRNMVN(nob+nextra,k,cov,nkmx,eps,nmx)
c
c   Generate data from linear vector autoregressive process:
c
	do i = 1,nob+nextra
		do ii = 1,k	
			x(i,ii) = eps(i,ii)
		enddo
		do j = 1,min(i-1,np)
			do l = 1,k
			do m = 1,k
				x(i,l) = x(i,l) + phi(j,l,m)*x(i-j,m)
			enddo
			enddo
		enddo
	enddo
c
	do i = 1,nob
	do j = 1,k
		x(i,j) = x(i+nextra,j)
	enddo
	enddo
c
	return
	end
